﻿#region usings
using System;
using System.Data;
using System.Drawing;
using System.Text;
using System.Xml;
using System.Windows;
using System.Windows.Forms;

using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.Threading;
using System.IO;

using AForge.Video;
using AForge.Video.VFW;
using AForge.Video.DirectShow;
using AForge.Imaging.Filters;
using AForge;
using AForge.Imaging;
#endregion

namespace Image_analyzer
{
	public partial class MainForm : Form
	{
		[STAThread]
        static void Main()
        {
        	try {
				Application.EnableVisualStyles();
	            Application.SetCompatibleTextRenderingDefault(false);
	            Application.Run(new MainForm());
			} catch (Exception err) {
      			MessageBox.Show("Programm wurde geschlossen:\r\n"+err.Message,"Anwendungsfehler");
			}
        }
		
        #region Variablen
        public bool f_test = true;
        //Camera
		VideoCaptureDevice video1;
		public VideoCaptureDevice video2;
		public FilterInfoCollection videosources = null;
		byte cam_droped = 0;
		int cam_H = 240;
		int cam_W = 320;
		int cam_fps = 25;
		int cam_fps_in_ms = 40;
		int cam_LastSel = 0;
		public bool working = false;
		
		bool main_autosize = true;
		bool lock_controls = true;
		bool mouse_left = false;
		Point mouse = Point.Empty;
		Point back = Point.Empty;
		int startmouse_y = 0;
		int startmouse_x = 0;
		int mouse_zooming = 0;
		int startcrop1 = 0;
		int startcrop2 = 0;
		int startcrop3 = 0;
		int startcrop4 = 0;
		Color Maus_col = Color.Lime;
		Bitmap back_avr = null;
		Bitmap img_cam2 = null;
        private int pic_nr = 0;
        public byte[] map_r = new byte[256];
        public byte[] map_g = new byte[256];
      	public byte[] map_b = new byte[256];
      	AVIReader AVI_read = new AVIReader();
      	AVIWriter AVI_write = new AVIWriter("msvc");
      	bool avi_stepup = false;
      	bool avi_stepdn = false;
      	bool avi_addframe = false;
      	bool avi_Record = false;
      	bool avi_Play = false;
      	bool avi_REPlay = true;
      	bool avi_isopen = false;
      	bool avi_speed = false;
      	int avi_speed_val = 0;
      	int avi_slow = 0;
      	int avi_steprange = 1;
      	int avi_fps_in_ms = 40;
      	int maus_zoombox = 150;
      	float maus_zoomfaktor = 10;
      	Color maus_farbe = Color.Lime;
      	bool maus_active = true;
      	bool maus_pseudo = false;
      	int Main_doResize = 0;
      	#endregion
      	
      	#region filtervariablen_forms
      	//filtervariablen ############################################
      	public bool Filt_Cam2 = false;
      	public bool Filt_Cam2_useFilter = false;
      	public int Filt_Cam2_num_H = 240;
      	public int Filt_Cam2_num_B = 320;
      	public int Filt_Cam2_num_X = 50;
      	public int Filt_Cam2_num_Y = 50;
      	public bool Filt_Siegeln = false;
      	public bool Filt_Siegeln_H = false;
      	public bool Filt_Siegeln_V = false;
      	public bool Filt_inter_vor = false;
      	public int Filt_inter_vor_val = 2;
      	public bool Filt_inter_vor_bic = false;
      	public bool Filt_inter_nach = false;
      	public int Filt_inter_nach_val = 2;
      	public bool Filt_inter_nach_bic = false;
      	public bool Filt_min = false;
      	public bool Filt_max = false;
      	public bool Filt_crop = false;
      	public bool Filt_crop_active = false;
      	public bool Filt_crop_new_set = false;
      	public bool Filt_crop_move = false;
      	public int Filt_crop_start_X = 1;
      	public int Filt_crop_stop_X = 352;
      	public int Filt_crop_start_Y = 1;
      	public int Filt_crop_stop_Y = 352;
      	public Color Filt_crop_color = Color.Lime;
      	public bool Filt_motion = false;
      	public Color Filt_motion_color = Color.Lime;
      	public bool Filt_motion_color_on = true;
      	public bool Filt_motion_AVR = true;
      	public int Filt_motion_AVR_val = 4;
      	public bool Filt_motion_TH = true;
      	public int Filt_motion_TH_val = 10;
      	public bool Filt_motion_surce = true;
      	public bool Filt_invert = false;
      	public bool Filt_nurKanten = false;
      	public bool Filt_susan = false;
      	public Color Filt_susan_color = Color.Lime;
      	public bool Filt_sharp = false;
      	public bool Filt_sharp2 = false;
      	public bool Filt_AS = false;
      	public bool Filt_AS_add = false;
      	public bool Filt_AS_substract = false;
      	public bool Filt_AS_diff = false;
      	public bool Filt_AS_hintergr = false;
      	public bool Filt_Verzerrung = false;
      	public bool Filt_Verzerrung_jitter = false;
      	public int Filt_Verzerrung_jitter_val = 0;
      	public bool Filt_Verzerrung_oil = false;
      	public int Filt_Verzerrung_oil_val = 0;
      	public bool Filt_Verzerrung_pixelate = false;
      	public bool Filt_Verzerrung_post = false;
      	public bool Filt_Verzerrung_W_on = false;
      	public int Filt_Verzerrung_W_1 = 3;
      	public int Filt_Verzerrung_W_2 = 15;
      	public int Filt_Verzerrung_W_3 = 3;
      	public int Filt_Verzerrung_W_4 = 15;
      	public bool Filt_binary = false;
      	public bool Filt_conv = false;
      	public int Filt_conv_1 = -2;
      	public int Filt_conv_2 = -1;
      	public int Filt_conv_3 = 0;
      	public int Filt_conv_4 = -1;
      	public int Filt_conv_5 = 0;
      	public int Filt_conv_6 = 1;
      	public int Filt_conv_7 = 0;
      	public int Filt_conv_8 = 1;
      	public int Filt_conv_9 = 2;
      	public bool Filt_median = false;
      	public int Filt_median_val = 1;
      	public bool Filt_Contrast = false;
      	public double Filt_Contrast_Cval = 1;
      	public double Filt_Contrast_Hval = 0;
      	public bool Filt_Color = false;
      	public bool Filt_Color_back_gray = false;
      	public bool Filt_Color_usetyp2 = true;
      	public Color Filt_Color_typ2 = Color.Fuchsia;
      	public byte Filt_Color_r1 = 0;
      	public byte Filt_Color_r2 = 140;
      	public byte Filt_Color_g1 = 124;
      	public byte Filt_Color_g2 = 0;
      	public byte Filt_Color_b1 = 0;
      	public byte Filt_Color_b2 = 180;
      	public bool Filt_Chan = false;
      	public byte Filt_Chan_r1 = 255;
      	public byte Filt_Chan_r2 = 0;
      	public byte Filt_Chan_g1 = 0;
      	public byte Filt_Chan_g2 = 0;
      	public byte Filt_Chan_b1 = 0;
      	public byte Filt_Chan_b2 = 0;
      	public bool Filt_EC = false;
      	public byte Filt_EC_r = 255;
      	public byte Filt_EC_g = 0;
      	public byte Filt_EC_b = 0;
      	public byte Filt_EC_rad = 100;
      	public bool Filt_Rotate1 = false;
      	public bool Filt_Rotate2 = false;
      	public bool Filt_Extract = false;
      	public bool Filt_Extract_R = true;
      	public bool Filt_Extract_G = false;
      	public bool Filt_Extract_B = false;
      	public bool Filt_PFill = false;
      	public Color Filt_PFill_col = Color.White;
      	public int Filt_PFill_R = 20;
      	public int Filt_PFill_G = 20;
      	public int Filt_PFill_B = 20;
      	public int Filt_PFill_X = 0;
      	public int Filt_PFill_Y = 0;
      	public bool Filt_PFill_set = false;
      	public bool Filt_AVR = false;
      	public int Filt_AVR_val = 5;
      	public bool Filt_Blob = false;
      	public bool Filt_Blob_showdata = true;
      	public bool Filt_Blob_TH = true;
      	public bool Filt_Blob_THshow = false;
      	public bool Filt_Blob_Abmessung = false;
      	public int Filt_Blob_TH_val = 80;
      	public int Filt_Blob_minY = 20;
      	public int Filt_Blob_minX = 20;
      	public Color Filt_Blob_color = Color.Lime;
      	public bool Filt_im_Hintergrund = false;
      	public bool Filt_ColBlob = false;
      	public int Filt_ColBlob_THval = 100;
      	public bool Filt_ColBlob_multicolor = true;
      	public bool Filt_ColBlob_skelett = false;
      	public bool Filt_ColBlob_kanten = false;
      	public bool Filt_Pseudo = false;
      	public bool Filt_Ebenen = false;
      	public bool Filt_Ebenen_1_on = false;
      	public bool Filt_Ebenen_2_on = false;
      	public int Filt_Ebenen_offsetX = 0;
      	public int Filt_Ebenen_offsetY = 0;
      	public int Filt_Ebenen_offsetX2 = 0;
      	public int Filt_Ebenen_offsetY2 = 0;
      	public bool Filt_Ebenen_0_trans_on = false;
      	public bool Filt_Ebenen_2_trans_on = false;
      	public Bitmap Ebene_1;
      	public Bitmap Ebene_2;
      	public Color Filt_Ebenen_0_C = Color.Fuchsia;
      	public Color Filt_Ebenen_2_C = Color.Fuchsia;
      	
      	FilterForm FF = new FilterForm();
      	public FilterForm FilterForm {
		    get { return FF; }
		    set { FF = value; }
		}
      	VideoForm VF = new VideoForm();
      	public VideoForm VideoForm {
		    get { return VF; }
		    set { VF = value; }
		}
      	#endregion
      	
      	void Do_something()
      	{
      		this.Text += " ("+SystemInformation.ComputerName+")";
      		this.SetStyle(ControlStyles.DoubleBuffer, true);
      		this.SetStyle(ControlStyles.AllPaintingInWmPaint, true);
      	}
      	
      	#region Mainform
      	public MainForm()
		{
			InitializeComponent();
			FF.MainForm = this;
			VF.MainForm = this;
			tcb_Bildformat.SelectedIndex = 0;
			tool_1_camera.Visible = false;
			tool_filter.Visible = false;
			panel_filter_setup.Visible = false;
			tool_0_sonstiges.Visible = false;
			toolStripContainer1.Width = this.Width - 8; //grundstellung
		}
      	void HauptformLoad(object sender, EventArgs e)
		{
			FF.CB_filter_palette.SelectedIndex = 2;
			P_pic_zoom.Width = 0;
			try {
				pic_backbox.Image = new Bitmap("test.jpg");
				Picbox1.Image = new Bitmap("test.jpg");
			} catch (Exception err) {
				MessageBox.Show("Beim laden von test.jpg gabs einen Fehler:\r\n"+err.Message,"Ladefehler");
				pic_backbox.Image = new Bitmap(640,480,PixelFormat.Format24bppRgb);
				Picbox1.Image = new Bitmap(640,480,PixelFormat.Format24bppRgb);
			}
			timer_off.Enabled = true;
			this.Width = 650;
			lock_controls = false;
			XML_Lesen();
			HauptformResizeEnd(null,null);
			Do_something();
		}
      	
      	void HauptformResizeEnd(object sender, EventArgs e)
		{
      		if (lock_controls) 
      		{
      			return;
      		}
			if (main_autosize) {
				int new_H = (int)((float)Picbox1.Width*((float)Picbox1.Image.Height/(float)Picbox1.Image.Width));
				int old_h = this.Height - Picbox1.Height;
				this.Height = new_H + old_h;
			}
		}
      	void HauptformFormClosing(object sender, FormClosingEventArgs e)
		{
			Kernel_schließe_kamera();
			XML_speichern();
			AVI_write.Close();
			AVI_read.Close();
			Application.Exit();
		}
      	void HauptformDragOver(object sender, DragEventArgs e)
		{
			if (e.Data.GetDataPresent(DataFormats.FileDrop))
			{	
				if ((e.AllowedEffect & DragDropEffects.Move) != 0)
				{
					e.Effect = DragDropEffects.Move;
				}
			}	
		}
		void HauptformDragDrop(object sender, DragEventArgs e)
		{
			try 
			{	
				if (e.Data.GetDataPresent (DataFormats.FileDrop))
				{	//versuche die gedropte datei als bild zu laden
					Kernel_schließe_kamera();
					string[] filepath = (string[]) e.Data.GetData (DataFormats.FileDrop);
					System.Drawing.Image image = System.Drawing.Image.FromFile (filepath[0]);
					Bitmap img = new Bitmap(image);
					img.SetResolution(96f,96f);
					img = img.Clone(new Rectangle(0, 0, img.Width, img.Height), PixelFormat.Format24bppRgb);
					pic_backbox.Image = img;
					Picbox1.Image = img;
					FF.Btn_crop_resetClick(sender, e);
					timer_off.Enabled = true;
				} 
			} catch (Exception err) 
			{
				MessageBox.Show(err.Message,"Drag&Drop fehlgeschlagen");
			}
		}
      	//mausbewegung tracken
		void Picbox1MouseEnter(object sender, EventArgs e)
		{
			if (maus_active) 
			{
				mousepanel_X1.Visible = true;
				mousepanel_X2.Visible = true;
				mousepanel_Y1.Visible = true;
				mousepanel_Y2.Visible = true;
				Cursor.Hide();
			}
		}
		void Picbox1MouseDown(object sender, MouseEventArgs e)
		{
        	if (e.Button.Equals(MouseButtons.Left)||
			    e.Button.Equals(MouseButtons.Right))
        	{
        		mouse_left = true;
        		mouse = new Point(e.X,e.Y);
        		startmouse_x = e.X;
        		startmouse_y = e.Y;
        		startcrop1 = Filt_crop_start_X;
        		startcrop2 = Filt_crop_start_Y;
        		startcrop3 = Filt_crop_stop_X;
        		startcrop4 = Filt_crop_stop_Y;
        	}
			if (Filt_crop_new_set) 
			{
				FF.num_crop1.Value = (decimal)(((double)Picbox1.Image.Height/(double)Picbox1.Height) * e.X);
				FF.num_crop3.Value = Filt_crop_start_X + 1; 
				FF.num_crop2.Value = (decimal)(((double)Picbox1.Image.Width/(double)Picbox1.Width) * e.Y);
				FF.num_crop4.Value = Filt_crop_start_Y + 1; 
			}
		}
		void Picbox1MouseMove(object sender, MouseEventArgs e)
		{
			if (maus_active) 
			{
				//vollbildkreuz ##############################
				//west
				mousepanel_Y1.Top = e.Y;
				mousepanel_Y1.Left = 1;
				mousepanel_Y1.Width = e.X - 4;
				//ost
				mousepanel_Y2.Top = e.Y;
				mousepanel_Y2.Left = e.X + 4;
				mousepanel_Y2.Width = Picbox1.Width - e.X - 6;
				//nord
				mousepanel_X1.Top = 2;
				mousepanel_X1.Left = e.X;
				mousepanel_X1.Height = e.Y - 5;
				//süd
				mousepanel_X2.Top = e.Y + 4;
				mousepanel_X2.Left = e.X;
				mousepanel_X2.Height = Picbox1.Height - e.Y - 6;
			}
			
			//Zuschnitt ##############################
        	if (e.Button.Equals(MouseButtons.Left)||
			    e.Button.Equals(MouseButtons.Right))
			{
        		mouse_left = true;
        		mouse = new Point(e.X,e.Y);
        		if (Filt_crop_move) 
        		{
        			//verhindern, dass außerhalb des bereichs geschoben wird
        			decimal new1 = e.X - startmouse_x + startcrop1;
        			decimal new2 = e.Y - startmouse_y + startcrop2;
        			decimal new3 = e.X - startmouse_x + startcrop3;
        			decimal new4 = e.Y - startmouse_y + startcrop4;
    				
        			if ((new1 > 0)&&
	        		    (new3 < Picbox1.Image.Width))
	    			{
	    				FF.num_crop1.Value = new1;
	    				FF.num_crop3.Value = new3;
	    			}
	    			if ((new2 > 0)&&
	        		    (new4 < Picbox1.Image.Height))
	    			{
	    				FF.num_crop2.Value = new2;
	    				FF.num_crop4.Value = new4;
	    			}
        		} //if (check_crop_move.Checked)
        		if (Filt_PFill_set) 
        		{
        			decimal X = ((decimal)Picbox1.Image.Width/(decimal)Picbox1.Width) * e.X;
        			decimal Y = ((decimal)Picbox1.Image.Height/(decimal)Picbox1.Height) * e.Y;
        			FF.num_pointfill_x.Value = X;
        			FF.num_pointfill_y.Value = Y;
        		}
        	}
			//zuschnitt2 ##############################
			if (Filt_crop_new_set &&
			    (startcrop1 != 0))
			{
				decimal new_x = (decimal)(((double)Picbox1.Image.Height/(double)Picbox1.Height) * e.X);
				decimal new_y = (decimal)(((double)Picbox1.Image.Width/(double)Picbox1.Width) * e.Y);
				if ((new_x <= FF.num_crop1.Value)||
				   	(new_y <= FF.num_crop2.Value)) 
				{
					return;
				}
				FF.num_crop3.Value = new_x;
				FF.num_crop4.Value = new_y;
			}
			//Zoom ##############################
			if ((mouse_zooming > 0)&&
			    (mouse_left))
			{
				if ((!e.Button.Equals(MouseButtons.Left))&&
				    (!e.Button.Equals(MouseButtons.Right))) 
				{
					return;
				}
				//verhindern, dass die Zoombox außerhalb des bildes wandert
				if (e.Y > ((P_pic_zoom.Width/2)+1))
				{ 
					if (e.Y < (Picbox1.Height - (P_pic_zoom.Width/2)))
					{ //nord
						P_pic_zoom.Top = e.Y - (P_pic_zoom.Width/2) - 2;
					}
					else
					{ //süd
						P_pic_zoom.Top = Picbox1.Height - P_pic_zoom.Height+1;
					}
				}
				else
				{
					P_pic_zoom.Top = 0;
				}
				if (e.X > ((P_pic_zoom.Width/2)-1))
				{ //west
					if (e.X < (Picbox1.Width - (P_pic_zoom.Width/2)-1)) 
					{ //ost
						P_pic_zoom.Left = e.X - (P_pic_zoom.Width/2) - 2;
					}
					else
					{
						P_pic_zoom.Left = Picbox1.Width - P_pic_zoom.Width - 1;
					}
				}
				else
				{
					P_pic_zoom.Left = 0;
				}

			}
			if ((mouse_zooming > 0)&&
				(!mouse_left))
			{
				mouse = new Point(e.X,e.Y);
			}
		}
		void Picbox1MouseUp(object sender, MouseEventArgs e)
		{
			startcrop1 = 0;
			if (e.Button.Equals(MouseButtons.Left)) 
			{
        		mouse_left = false;
        	}
			if (Filt_crop_new_set) 
			{
				FF.check_crop_bereich.Checked = false;
			}
		}
		void Picbox1MouseLeave(object sender, EventArgs e)
		{
			if (maus_active) 
			{
				Cursor.Show();
				mousepanel_X1.Visible = false;
				mousepanel_X2.Visible = false;
				mousepanel_Y1.Visible = false;
				mousepanel_Y2.Visible = false;
			}
		}
		
		void Pic_zoomMouseEnter(object sender, EventArgs e)
		{
			Cursor.Hide();
		}
		void Pic_zoomMouseLeave(object sender, EventArgs e)
		{
			Cursor.Show();
		}
		void Pic_zoomMouseDown(object sender, MouseEventArgs e)
		{
			if (e.Button == MouseButtons.Right) 
			{
				mouse_left = false;
			}
		}
      	//filterbox
      	void Label_filter_setup2Click(object sender, EventArgs e)
		{
			panel_filter_setup.Visible = false;
		}
		void Label_filter_setupMouseDown(object sender, MouseEventArgs e)
		{
			label_filter_setup.BackColor = Color.RoyalBlue;
			startmouse_x = e.X;
			startmouse_y = e.Y;
		}
		void Label_filter_setupMouseUp(object sender, MouseEventArgs e)
		{
			label_filter_setup.BackColor = Color.LightSteelBlue;
		}
		void Label_filter_setupMouseMove(object sender, MouseEventArgs e)
		{
			if (e.Button == MouseButtons.Left) 
			{
				panel_filter_setup.Top += e.Y - startmouse_y;
				panel_filter_setup.Left += e.X - startmouse_x;
			}
		}
		
      	#endregion
		
		#region Kamera_XML
		void video_NewFrame(object sender, NewFrameEventArgs eventArgs)
        {	
			pic_backbox.Image = (Bitmap)eventArgs.Frame.Clone();
        }
		public void video_NewFrame2(object sender, NewFrameEventArgs eventArgs)
        {	
			img_cam2 = (Bitmap)eventArgs.Frame.Clone();
        }
		
		void Kernel_suche_kameras()
		{
			CB_cam_devices.Items.Clear();
			FF.CB_cam_devices2.Items.Clear();
        	cam_droped = 0;
        	Kernel_schließe_kamera();
        	FF.Kernel_schließe_kamera2();
        	//video_combobox mit neuem Inhalt füllen
        	videosources = new FilterInfoCollection(FilterCategory.VideoInputDevice);
            if (videosources.Count != 0)
            {
            	CB_cam_devices.Items.Add("Keine Kamera");
                FF.CB_cam_devices2.Items.Add("Keine Kamera");
            	foreach (FilterInfo videosource in videosources)
                {
                	cam_droped++;
                    CB_cam_devices.Items.Add("("+cam_droped+") "+videosource.Name);
                    FF.CB_cam_devices2.Items.Add("("+cam_droped+") "+videosource.Name);
                }
                CB_cam_devices.ForeColor = Color.FromArgb(0,180,180,0);
                CB_cam_devices.SelectedIndex = 1;
                FF.CB_cam_devices2.ForeColor = Color.FromArgb(0,180,180,0);
                if (videosources.Count > 1) {
                	FF.CB_cam_devices2.SelectedIndex = 2;
                } else {
                	FF.CB_cam_devices2.SelectedIndex = 1;
                }
            } else {
                CB_cam_devices.Items.Add("no Cam found");
                CB_cam_devices.ForeColor = Color.FromArgb(0,255,0,0);
                CB_cam_devices.SelectedIndex = 0;
                FF.CB_cam_devices2.Items.Add("no Cam found");
                FF.CB_cam_devices2.ForeColor = Color.FromArgb(0,255,0,0);
                FF.CB_cam_devices2.SelectedIndex = 0;
            }
            TBtn_cam_suchen.Text = "Suche Kameras ("+videosources.Count+")";
            
		}
		void Kernel_öffne_kamera()
		{
			working = false;
        	if ((CB_cam_devices.SelectedIndex > 0) && (video1 == null))
            {	//videoquelle starten
        		timer_off.Enabled = false;
                video1 = new VideoCaptureDevice(videosources[CB_cam_devices.SelectedIndex-1].MonikerString);
            	video1.NewFrame += new NewFrameEventHandler(video_NewFrame);
                video1.DesiredFrameRate = cam_fps;
                timer_on.Interval = cam_fps_in_ms;
                video1.DesiredFrameSize = new Size(cam_W, cam_H);
                video1.Start();
                pic_nr = 0;
                cam_droped = 0;
                timer_on.Enabled = true;
                //crop aktualisieren
                FF.num_crop1.Value = 1;
				FF.num_crop2.Value = 1;
				FF.num_crop3.Value = cam_W - 1;
				FF.num_crop4.Value = cam_H - 1;
                if (video1.IsRunning == true) 
                {
                	CB_cam_devices.ForeColor = Color.FromArgb(0,0,180,0);
                	tcb_cam_auflösungen.Enabled = true;
                	if (cam_LastSel != CB_cam_devices.SelectedIndex) {
                		//wenn device geändert, auflösungen aktualisieren
                		try {
	                		tcb_cam_auflösungen.Items.Clear();
		                	Application.DoEvents(); Thread.Sleep(300);
							int menge = video1.VideoCapabilities.Length;
							for (int i = 0;i<menge ;i++ ) {
								string setting = video1.VideoCapabilities[i].FrameSize.Height.ToString()+"x"+video1.VideoCapabilities[i].FrameSize.Width.ToString()+
									" @"+video1.VideoCapabilities[i].MaxFrameRate.ToString();
								tcb_cam_auflösungen.Items.Add(setting);
							}
							tcb_cam_auflösungen.SelectedIndex = 0;
	                		cam_LastSel = CB_cam_devices.SelectedIndex;
                		} catch (Exception err) {
                			MessageBox.Show(err.Message,"Fehler beim auslesen der Auflösungen");
                		}
                	}
                }
            }
		}
		void Kernel_schließe_kamera()
		{
			if (!(video1 == null)){
                if (video1.IsRunning) {
                    video1.SignalToStop();
                    Application.DoEvents();
                }
				video1 = null;
			}
			tcb_cam_auflösungen.Enabled = false;
			timer_on.Enabled = false;
			timer_off.Enabled = true;
            CB_cam_devices.ForeColor = Color.FromArgb(0,255,0,0);
            working = false;
		}
		
		
		void XML_speichern()
		{
			do_XML.schreibe_XML("Func1",btn_func_Kamera.ForeColor.ToKnownColor().ToString());
			do_XML.schreibe_XML("Func2",btn_func_video.ForeColor.ToKnownColor().ToString());
			do_XML.schreibe_XML("Func3",btn_func_filter.ForeColor.ToKnownColor().ToString());
			do_XML.schreibe_XML("Func4",btn_func_sonstiges.ForeColor.ToKnownColor().ToString());
			do_XML.schreibe_XML("Func5",filterToolStripMenuItem.ForeColor.ToKnownColor().ToString());
			do_XML.schreibe_XML("Func6",VideoToolStripMenuItem.ForeColor.ToKnownColor().ToString());
		}
		void XML_Lesen()
		{
			string read_s = "";
			read_s = do_XML.lese_XML("Func1");
			if (read_s == "Lime") {
				btn_func_Kamera.PerformClick();
			}
			read_s = do_XML.lese_XML("Func2");
			if (read_s == "Lime") {
				btn_func_video.PerformClick();
			}
			read_s = do_XML.lese_XML("Func3");
			if (read_s == "Lime") {
				btn_func_filter.PerformClick();
			}
			read_s = do_XML.lese_XML("Func4");
			if (read_s == "Lime") {
				btn_func_sonstiges.PerformClick();
			}
			read_s = do_XML.lese_XML("Func5");
			if (read_s == "Lime") {
				filterToolStripMenuItem.PerformClick();
			}
			read_s = do_XML.lese_XML("Func6");
			if (read_s == "Lime") {
				VideoToolStripMenuItem.PerformClick();
			}
		}
		#endregion
		
		#region AVI_video
		void AVI_readFrame(bool direkt)
		{
			if (!avi_isopen) 
			{
				return;
			}
			int a_stop = AVI_read.Length;
			int a_pos = AVI_read.Position;
			if (avi_Play||avi_stepdn||avi_stepup||direkt)
			{
				if (avi_stepup) {
					if (Bar_video_reader.Value < a_stop - 1) 
					{
						Bar_video_reader.Value += avi_steprange - 1;
					} else {
						Bar_video_reader.Value = a_stop - 1;
					}
				} else if (avi_stepdn) {
					if (Bar_video_reader.Value >= avi_steprange + 1) 
					{
						Bar_video_reader.Value -= avi_steprange + 1;
					} else {
						Bar_video_reader.Value = 0;
					}
				} else if (avi_speed) 
				{
					switch (avi_speed_val) {
						case 6: Bar_video_reader.Value += 6; break;
						case 5: Bar_video_reader.Value += 3; break;
						case 4: break;
						case 3: if (avi_slow == 0) { avi_slow = 1; } else { avi_slow--; return; } break;
						case 2: if (avi_slow == 0) { avi_slow = 3; } else { avi_slow--; return; } break;
						case 1: if (avi_slow == 0) { avi_slow = 5; } else { avi_slow--; return; } break;
						case 0: if (Bar_video_reader.Value > 0) { Bar_video_reader.Value--;} break;
						case -1: if (avi_slow == 0) { avi_slow = 5; if (Bar_video_reader.Value > 0) 
							{ Bar_video_reader.Value-=2;} } else { avi_slow--; return; } break;
						case -2: if (avi_slow == 0) { avi_slow = 3; if (Bar_video_reader.Value > 0) 
							{ Bar_video_reader.Value-=2;} } else { avi_slow--; return; } break;
						case -3: if (avi_slow == 0) { avi_slow = 1; if (Bar_video_reader.Value > 0) 
							{ Bar_video_reader.Value-=2;} } else { avi_slow--; return; } break;
						case -4: if (Bar_video_reader.Value > 1) { Bar_video_reader.Value-=2;} break;
						case -5: if (Bar_video_reader.Value > 3) { Bar_video_reader.Value-=4;} break;
						case -6: if (Bar_video_reader.Value > 6) { Bar_video_reader.Value-=7;} break;
					}
				}
				//step up/dn fertig
				AVI_read.Position = Bar_video_reader.Value;
				if (a_pos + 1 < a_stop) 
				{
					pic_backbox.Image = AVI_read.GetNextFrame();
				} else { //video durchgelaufen
					if (avi_REPlay)
					{
						AVI_read.Position = AVI_read.Start;
					} else {
						CHK_video_Play.Checked = false;
						Application.DoEvents();
					}
				}
				Bar_video_reader.Value = AVI_read.Position;
				Kernel_refresh_positiondata();
			}
		}
		void AVI_writeFrame(Bitmap img)
		{
			if (btn_video_erstellen.ForeColor != Color.Lime) 
			{
				return;
			}
			if (avi_addframe||avi_Record)
			{
				try {
					AVI_write.AddFrame(img);
				} catch (Exception) 
				{
					info_err.Visible = true;
					info_err.Text = "Größenunterschied erkannt:\r\n"
						+ "H:"+img.Height.ToString()+" W:"+img.Width.ToString()+" H2:"+AVI_write.Height.ToString()+" W2:"+AVI_write.Width.ToString();
					Application.DoEvents();
					Thread.Sleep(300);
					CHK_video_record.Checked = false;
				}
				int sec = AVI_write.Position/(int)AVI_write.FrameRate;
				int min = 0;
				while (sec > 59) {
					min++;
					sec -= 60;
				}
				label_video_position_rec.Text = min.ToString()+":"+sec.ToString()+
					" ("+AVI_write.Position.ToString()+")";
				avi_addframe = false;
			}
		}
		
		void Kernel_öffne_AVI()
		{
			try 
			{
				if (!avi_isopen) 
				{
					if (openFileDialog1.ShowDialog() == DialogResult.OK) 
					{
						AVI_read.Open(openFileDialog1.FileName);
						Bar_video_reader.Minimum = AVI_read.Start;
						Bar_video_reader.Value = AVI_read.Start;
						Bar_video_reader.Maximum = AVI_read.Length;
						Kernel_refresh_positiondata();
						but_video_openfile.ForeColor = Color.Lime;
						but_video_openfile.Text = "Datei schließen";
						avi_isopen = true;
					}
				} else {
					AVI_read.Close();
					avi_isopen = false;
					but_video_openfile.ForeColor = Color.Red;
					but_video_openfile.Text = "Geschlossen";
				}
			} 
			catch (Exception err)
			{
				MessageBox.Show(err.Message,"Fehler beim öffnen");
				avi_isopen = false;
				but_video_openfile.ForeColor = Color.Red;
				but_video_openfile.Text = "Fehler...";
			}
		} //testmodus
		void Kernel_erstelle_AVI()
		{
			try 
			{
				CHK_video_record.Checked = false;
				Application.DoEvents();
				if (btn_video_erstellen.ForeColor == Color.Red) {
					if (CB_video_codecs.SelectedItem == null) {
						MessageBox.Show("Es wurde noch kein Codec für das Video ausgewählt.");
						return;
					}
					AVI_write.Codec = CB_video_codecs.SelectedItem.ToString();
					AVI_write.FrameRate = (int)num_avi_FPS.Value;
					AVI_write.Open( TXT_avi_writerfilename.Text, (int)num_avi_W.Value, (int)num_avi_H.Value);
					btn_video_erstellen.ForeColor = Color.Lime;
					btn_video_erstellen.Text = "Datei schließen";
				} else {
					AVI_write.Close();
					btn_video_erstellen.ForeColor = Color.Red;
					btn_video_erstellen.Text = "Erstellen";
				}
			} 
			catch (Exception err)
			{
				MessageBox.Show(err.Message,"Fehler beim erstellen");
				btn_video_erstellen.ForeColor = Color.Red;
				btn_video_erstellen.Text = "Fehler...";
			}
		}
		void Kernel_refresh_positiondata()
		{
			int sec = AVI_read.Position/(int)AVI_read.FrameRate;
			int min = 0;
			while (sec > 59) {
				min++;
				sec -= 60;
			}
			label_video_position_read.Text = min.ToString()+":"+sec.ToString()+
				" ("+AVI_read.Position.ToString()+")";
			avi_stepdn = false;
			avi_stepup = false;
		}
		#endregion
		
		#region Imageprocessing
		void ImageProcessing(ref Bitmap image)
        {
        	try 
        	{
	        	working = true;
	        	//####################################################
	        	//vorfilter
	        	if (Filt_inter_vor) {
					if (Filt_inter_vor_bic) {
						ResizeBicubic bic1 = new ResizeBicubic( image.Width / Filt_inter_vor_val, image.Height / Filt_inter_vor_val );
						image = bic1.Apply(image);
					} else {
						ResizeBilinear bil1 = new ResizeBilinear( image.Width / Filt_inter_vor_val, image.Height / Filt_inter_vor_val );
						image = bil1.Apply(image);
					}
	        	}
	        	if (Filt_crop) {
		        	if (Filt_crop_active) {
		        		Crop CR = new Crop(new Rectangle(Filt_crop_start_X, Filt_crop_start_Y, 
		        		                                 Filt_crop_stop_X-Filt_crop_start_X, Filt_crop_stop_Y-Filt_crop_start_Y));
						image = CR.Apply(image);
		        	} else {
			        		Graphics g = Graphics.FromImage(image);
			        		Pen p1 = new Pen(Filt_crop_color, 1);
			        		g.DrawRectangle(p1,new Rectangle(Filt_crop_start_X, Filt_crop_start_Y, 
			        		                                 Filt_crop_stop_X-Filt_crop_start_X, Filt_crop_stop_Y-Filt_crop_start_Y));
		        	}
	        	}
	        	if (Filt_Siegeln) {
	        		Mirror mir = new Mirror( Filt_Siegeln_H, Filt_Siegeln_V );
					mir.ApplyInPlace( image );
	        	}
	        	if (Filt_Cam2_useFilter) {
		        	if (Filt_Cam2) {
		        		Graphics G = Graphics.FromImage(image);
		        		ResizeBilinear RB = new ResizeBilinear(Filt_Cam2_num_B, Filt_Cam2_num_H);
		        		img_cam2 = RB.Apply(img_cam2);
		        		G.DrawImage(img_cam2,new Point(Filt_Cam2_num_X,Filt_Cam2_num_Y));
		        	}
	        	}
	        	
	        	//kopie erstellen, auf die die filter angewendet werden
	        	Bitmap img = image;
	        	
	        	//####################################################
	        	//filter 1 und filter 2
	        	
	        	filter(ref img);
	        	//####################################################
	        	//nachfilter
	        	if (Filt_motion) {
	        		IFilter GS = new Grayscale(0.33, 0.33, 0.33);
	        		Bitmap tmp = GS.Apply(img);
	        		if (FF.pic_motion.Image == null) {
	        			FF.pic_motion.Image = tmp;
	        			working = false;
	        			return;
	        		}
	        		if (Filt_motion_AVR) {
		        		if (back_avr == null) { back_avr = tmp; }
			            Morph f_morp = new Morph(back_avr);
					    f_morp.SourcePercent = 1 / (double)Filt_motion_AVR_val;
					    tmp = f_morp.Apply(tmp);
					    back_avr = tmp;
	        		}
	        		//differenzen in den graustufenbildern erkennen
	        		Difference DIF = new Difference((Bitmap)FF.pic_motion.Image.Clone());
	        		FF.pic_motion.Image = tmp;
	        		tmp = DIF.Apply(tmp);
	        		
	        		if (Filt_motion_TH) {
	        			Threshold TH = new Threshold(Filt_motion_TH_val);
	        			TH.ApplyInPlace(tmp);
	        		}
	        		//damit andere Filter noch angewendet werden können
	        		GrayscaleToRGB GRGB = new GrayscaleToRGB();
					tmp = GRGB.Apply(tmp);
					if (Filt_motion_color_on) {
						ColorFiltering f_col = new ColorFiltering();
			    		f_col.Red = new IntRange(0, 0);
			        	f_col.Green = new IntRange(0, 0);
						f_col.Blue = new IntRange(0, 0);
			        	f_col.FillColor = new RGB(Filt_motion_color);
			        	tmp = f_col.Apply(tmp);
					}
	        		if (Filt_motion_surce) {
	        			Merge mer = new Merge(img);
						img = mer.Apply(tmp);
	        		} else {
	        			img = tmp;
	        		}
	        	}
	        	
	        	if (Filt_Pseudo) {
	        		do_main_pseudocolor(ref img);
	        	}
	        	if (Filt_AVR) {	//Average
	        		if (pic_backfilter.Image != null) {
	        			Morph f_morph = new Morph((Bitmap)pic_backfilter.Image);
				        f_morph.SourcePercent = 1 / (double)Filt_AVR_val;
				        img = f_morph.Apply(img);
				        pic_backfilter.Image = img;
	        		} else {
        				pic_backfilter.Image = img;
	        		}
	        	}
	        	if (Filt_inter_nach) {
	        		if (Filt_inter_nach_bic) {
						ResizeBicubic bic2 = new ResizeBicubic( img.Width * Filt_inter_nach_val, img.Height * Filt_inter_nach_val );
						img = bic2.Apply(img);
					} else {
						ResizeBilinear bil2 = new ResizeBilinear( img.Width * Filt_inter_nach_val, img.Height * Filt_inter_nach_val );
						img = bil2.Apply(img);
					}
	        	}
	        	if (maus_active & mouse_left) {
	        		mouse_zooming++;
	        		mousezoom(ref img);
	        		working = false;
	        		return;
	        	}
	        	if (mouse_zooming > 0) {
	        		mouse_zooming--;
	        		mousezoom(ref img);
	        		working = false;
	        		return;
	        	}
	        	if (Filt_ColBlob) {
	        		//bild in graustufen umwandeln
		        	IFilter grayscale = new Grayscale( 0.33, 0.33, 0.33);          
		            img = grayscale.Apply(img);
		            Threshold TH_filter = new Threshold(Filt_ColBlob_THval);
		            TH_filter.ApplyInPlace(img);
		            if (Filt_ColBlob_multicolor) {
			            ConnectedComponentsLabeling CCL = new ConnectedComponentsLabeling( );
						img = CCL.Apply(img);
						FF.label_filter_objektcolor.Text = CCL.ObjectCount.ToString();
		            }
		            if (Filt_ColBlob_skelett) {
		            	SimpleSkeletonization Skel = new SimpleSkeletonization();
						Skel.ApplyInPlace(img);
		            }
		            if (Filt_ColBlob_kanten) {
		            	SobelEdgeDetector SED = new SobelEdgeDetector();
		            	SED.ApplyInPlace(img);
		            }
	        	}
	        	if (Filt_Blob) {
	        		//bild in graustufen umwandeln
		        	IFilter grayscale = new Grayscale( 0.33, 0.33, 0.33);          
		            Bitmap tmp = grayscale.Apply(img);
		            if (Filt_Blob_TH) {
		            	Threshold TH_filter = new Threshold(Filt_Blob_TH_val);
						TH_filter.ApplyInPlace(tmp);
						if (Filt_Blob_THshow) {
							Picbox1.Image = tmp;
							working = false;
	        				info_err.Visible = false;
							return;
						}
		            }
					//Objektcounter erstellen
					BlobCounter bc = new BlobCounter();
					bc.FilterBlobs = true;
					bc.MinHeight = Filt_Blob_minY;
					bc.MinWidth = Filt_Blob_minX;
					if (Filt_Blob_Abmessung) {
						bc.ObjectsOrder = ObjectsOrder.Size;
					} else {
						bc.ObjectsOrder = ObjectsOrder.Area;
					}
					//bild auf objekte untersuchen
					//gefundene in ein rechteck objektarray speichern
					BitmapData bitmapData = tmp.LockBits(new Rectangle(0, 0, img.Width-1, img.Height-1),
		            ImageLockMode.ReadWrite, PixelFormat.Format8bppIndexed);
					bc.ProcessImage(bitmapData);
					tmp.UnlockBits(bitmapData);
		            tmp.Dispose();
		            FF.label_blob_objekts.Text = bc.ObjectsCount.ToString();
					Rectangle[] rects = bc.GetObjectsRectangles();
					Blob[] blobs = bc.GetObjectsInformation( );
					//dank "ObjectsOrder.Area" wird das objekt
					//mit den meißten pixeln im index 0 liegen
					if (rects.Length > 0) {
						//Mittelpunkt
						int x = rects[0].X+(rects[0].Width/2);
			            int y = rects[0].Y+(rects[0].Height/2);
						back = new Point(x, y);
						//rechteck und werte auf dem bild anzeigen
			            if (Filt_Blob_showdata) {	
			            	if (Filt_im_Hintergrund) {	
				            	Drawrect(ref image, back,rects[0],blobs[0]);
				            } else {
				            	Drawrect(ref img, back,rects[0],blobs[0]);
				            }
			        	}
					}
	        	}
	        	if (!Filt_Cam2_useFilter) {
		        	if (Filt_Cam2) {
		        		Graphics G = Graphics.FromImage(image);
		        		ResizeBilinear RB = new ResizeBilinear(Filt_Cam2_num_B, Filt_Cam2_num_H);
		        		img_cam2 = RB.Apply(img_cam2);
		        		G.DrawImage(img_cam2,new Point(Filt_Cam2_num_X,Filt_Cam2_num_Y));
		        	}
	        	}
	        	if (Filt_im_Hintergrund) {
	            	Picbox1.Image = image;
	        		AVI_writeFrame(image);
	            } else {
		        	if (Filt_Ebenen_1_on) {
	        			Bitmap back = (Bitmap)FF.pic_ebene_1.Image.Clone();
        				Graphics G = Graphics.FromImage(back);
	        			if (Filt_Ebenen_0_trans_on) {
	        				img.MakeTransparent(Filt_Ebenen_0_C);
	        			}
	        			G.DrawImage(img,Filt_Ebenen_offsetX,Filt_Ebenen_offsetY);
	        			FF.pic_addbox.Image = (Bitmap)img.Clone();
	        			if (Filt_Ebenen_2_on) {
		        			if (Filt_Ebenen_2_trans_on) {
	        					Ebene_2 = (Bitmap)FF.pic_ebenen_2.Image.Clone();
		        				Ebene_2.MakeTransparent(Filt_Ebenen_2_C);
	        				}
		        			G.DrawImage(Ebene_2,Filt_Ebenen_offsetX2,Filt_Ebenen_offsetY2);
	        			}
	        			Picbox1.Image = back;
		        	} else {
		        		Picbox1.Image = img;
		        	}
	        		AVI_writeFrame(img);
	        	}
	        	if (Main_doResize > 0) {
	        		Main_doResize--;
	        		if (Main_doResize==0) {
	        			Application.DoEvents();
						HauptformResizeEnd(null,null);
	        		}
				}
	        	working = false;
	        	info_err.Visible = false;
        	} 
        	catch (Exception err) 
        	{
        		info_err.Visible = true;
        		info_err.Text = "Fehler in (ImageProcessing):\r\n"+err.Message;
//        		StreamWriter txt = new StreamWriter("ImageProcessing_errors.txt",true);
//        		txt.WriteLine(DateTime.Now.ToLongTimeString()+"\t"+err.Message);
//        		txt.Close();
        		working = false;
        	}
        }
        void mousezoom(ref Bitmap img)
        {
        	if (Filt_crop_move||
        	    Filt_crop_new_set||
        	   Filt_PFill_set)
        	{	//beim crop erstellen und verschieben nicht zoomen
        		Picbox1.Image = img;
        		return;
        	}
    		//variablen und objekte erstellen
    		int zoomstufen = 5;
    		if (mouse_zooming > zoomstufen)
    		{
    			mouse_zooming = zoomstufen;
    		}
    		
			Graphics g = Graphics.FromImage(img);
        	Pen p1 = new Pen(Maus_col, 1);
        	Font f = new Font("Arial", 8);
        	SolidBrush br = new SolidBrush(Maus_col);
            Point pos = new Point((int)(((float)img.Width / (float)Picbox1.Width) * mouse.X),
                                  (int)(((float)img.Height / (float)Picbox1.Height) * mouse.Y));
        	int zoom = maus_zoombox; //ziel
        	int zoom0 = (int)((maus_zoomfaktor / (float)Picbox1.Width)*1000); //start
            
        	if (mouse_zooming > 0)
    		{
        		P_pic_zoom.Width = zoom + 4;
        		P_pic_zoom.Height = zoom + 4;
        		pic_zoom.Width = zoom;
        		pic_zoom.Height = zoom;
        		zoom = (zoom * zoomstufen) / (mouse_zooming+1);
        		zoom0 = (zoom0 * zoomstufen) / (mouse_zooming+1);
    		}
        	else
        	{
        		P_pic_zoom.Width = 0;
        		zoom = (zoom/10);
        		zoom0 = (zoom0/10);
        	}
            //neues bild an der mausposition ausschneiden
            Crop filter_c = new Crop(new Rectangle(pos.X-(zoom0 / 2),pos.Y-(zoom0 / 2),zoom0,zoom0));
			Bitmap newImage = filter_c.Apply(img);
			//neues bild zoomen
			ResizeBilinear filter2 = new ResizeBilinear(zoom, zoom);
	        newImage = filter2.Apply(newImage);
	        if (maus_pseudo) 
	        {
	        	//wenn zoomfenster in pseudocolor dargestellt werden soll
	        	do_main_pseudocolor(ref newImage);
	        }
	        //zeichne zoombild ins hauptbild
	        pic_zoom.Image = newImage;
			
			listBox_maus.Items.Clear();
			listBox_maus.Items.Add("PixelFormat: "+img.PixelFormat);
			listBox_maus.Items.Add("Auflösung: "+img.HorizontalResolution+" DPI");
			listBox_maus.Items.Add("Bildgröße: W="+img.Width+" H="+img.Height);
			listBox_maus.Items.Add("Position IMG: X="+pos.X+" Y="+pos.Y);
			listBox_maus.Items.Add("Position Maus: X="+mouse.X+" Y="+mouse.Y);
			listBox_maus.Items.Add("debug Picbox1: H="+Picbox1.Height+" W="+Picbox1.Width);
	        listBox_maus.Items.Add("debug form: H="+this.Height+" W="+this.Width);
            //hauptbild ausgeben
            Picbox1.Image = img;
        }
        void filter(ref Bitmap img)
        {
        	//##########################################################
        	//filter 1
        	if (f_test) {
        		//zum testen
        	}
        	if (Filt_invert) {
        		Invert f_inv = new Invert();
        		img = f_inv.Apply(img);
        	}
        	if (Filt_Verzerrung) {
	        	if (Filt_Verzerrung_oil) {
	        		OilPainting OIL = new OilPainting(Filt_Verzerrung_oil_val);
					OIL.ApplyInPlace(img);
	        	}
	        	if (Filt_Verzerrung_pixelate) {
	        		Pixellate PIX = new Pixellate();
					PIX.ApplyInPlace(img);
	        	}
	        	if (Filt_Verzerrung_jitter) {
	        		Jitter jit = new Jitter(Filt_Verzerrung_jitter_val);
	        		jit.ApplyInPlace(img);
	        	}
	        	if (Filt_Verzerrung_post) {
	        		SimplePosterization Post = new SimplePosterization();
					Post.ApplyInPlace(img);
	        	}
	        	if (Filt_Verzerrung_W_on) {
					WaterWave WW = new WaterWave( );
					WW.HorizontalWavesCount     = Filt_Verzerrung_W_1;
					WW.HorizontalWavesAmplitude = Filt_Verzerrung_W_2;
					WW.VerticalWavesCount       = Filt_Verzerrung_W_3;
					WW.VerticalWavesAmplitude   = Filt_Verzerrung_W_4;
					img = WW.Apply( img );
	        	}
        	}
        	if (Filt_binary) {
        		IFilter IF = new Grayscale(0.33, 0.33, 0.33);
        		img = IF.Apply(img);
        		FloydSteinbergDithering FSD = new FloydSteinbergDithering();
				FSD.ApplyInPlace(img);
				GrayscaleToRGB GRGB = new GrayscaleToRGB();
				img = GRGB.Apply(img);
        	}
        	if (Filt_AS) {
        		if (pic_backfilter.Image != null) {
        			if (Filt_AS_add) {
        				Add f_add = new Add((Bitmap)FF.pic_addbox.Image.Clone());
        				img = f_add.Apply(img);
        			}
        			if (Filt_AS_substract) {
        				Subtract SUB = new Subtract( (Bitmap)FF.pic_addbox.Image.Clone() );
						img = SUB.Apply( img );
        			}
        			if (Filt_AS_diff) {
        				Difference diff = new Difference( (Bitmap)FF.pic_addbox.Image.Clone() );
        				img = diff.Apply(img);
        			}
        			if (Filt_AS_hintergr) {
        				FlatFieldCorrection ffc = new FlatFieldCorrection( (Bitmap)FF.pic_addbox.Image.Clone());
						ffc.ApplyInPlace(img);
		        	} 
        		} else {
        			 pic_backfilter.Image = img;
        		}
        	}
        	if (Filt_sharp) {
        		Sharpen SH = new Sharpen();
        		SH.ApplyInPlace(img);
        	}
        	if (Filt_sharp2) {
        		GaussianSharpen GS = new GaussianSharpen(4, 11);
				GS.ApplyInPlace(img);
        	}
        	if (Filt_Contrast) {
        		ContrastCorrection contrast = new ContrastCorrection();
        		contrast.Factor = Filt_Contrast_Cval;
				contrast.ApplyInPlace(img);
				BrightnessCorrection bright = new BrightnessCorrection();
				bright.AdjustValue = Filt_Contrast_Hval;
				bright.ApplyInPlace( img );
        	}
        	if (Filt_conv) {
        		int[,] kernel = {
        			{Filt_conv_1, Filt_conv_2, Filt_conv_3},
            		{Filt_conv_4, Filt_conv_5, Filt_conv_6},
            		{Filt_conv_7, Filt_conv_8, Filt_conv_9} };
        		Convolution f_blur = new Convolution(kernel);
        		img = f_blur.Apply(img);
        	}
        	if (Filt_nurKanten) {
        		IFilter _IF = new Grayscale(0.2125, 0.7154, 0.0721);
        		img = _IF.Apply(img);
        		DifferenceEdgeDetector DD = new DifferenceEdgeDetector();
				DD.ApplyInPlace(img);
				GrayscaleToRGB DD_rgb = new GrayscaleToRGB();
			    img = DD_rgb.Apply(img);
        	}
        	if (Filt_median) 
        	{	//mittelt jeden pixel zu seinem nachbarn (einstellung entspricht pixelreichweite)
        		Median f_medi = new Median();
        		f_medi.Size = Filt_median_val;
				img = f_medi.Apply(img);	
        	}
        	if (Filt_min || Filt_max) {
        		if (pic_backfilter.Image != null) {
	        		if (Filt_max) {
	        			Merge mer = new Merge( (Bitmap)pic_backfilter.Image );
						img = mer.Apply( img );
	        		}
	        		if (Filt_min) {
	        			Intersect inter = new Intersect( (Bitmap)pic_backfilter.Image );
						img = inter.Apply( img );
	        		}
	        		pic_backfilter.Image = img;
        		} else {
        			 pic_backfilter.Image = img;
        		}
        		
        	}
        	if (Filt_susan) 
        	{	//markiert gefundene ecken mit einem farbpunkt
        		SusanCornersDetector scd = new SusanCornersDetector();
				CornersMarker CM = new CornersMarker(scd, Filt_susan_color);
        		img = CM.Apply(img);
        	}
        	//##########################################################
        	//filter 2
        	if (Filt_Color)
			{	//filtert rgb pixel (weiß = r&g&b)
        		if (Filt_Color_usetyp2) {
	        		UnsafeBitmap ubmp = new UnsafeBitmap(img);
	        		ubmp.LockBitmap();
	        		for (int x=0;x<img.Width;x++) {
	        			for (int y=0;y<img.Height;y++) {
	        				PixelData P = ubmp.GetPixel(x,y);
	        				if ((P.green>Filt_Color_g1&&P.blue<Filt_Color_b2&&P.red<Filt_Color_r2)) {
	        					//referenzfarbe überschreiben
	        					P.red = Filt_Color_typ2.R; P.green = Filt_Color_typ2.G; P.blue = Filt_Color_typ2.B; 
	        					ubmp.SetPixel(x,y,P);
	        				} else {
	        					ubmp.SetPixel(x,y,P);
	        				}
	        			}
	        		}
	        		ubmp.UnlockBitmap();
	        		img = (Bitmap)ubmp.Bitmap.Clone();
        		} else {
        			ColorFiltering f_col = new ColorFiltering();
			    	f_col.Red = new IntRange(Filt_Color_r2, Filt_Color_r1);
			        f_col.Green = new IntRange(Filt_Color_g2, Filt_Color_g1);
			        f_col.Blue = new IntRange(Filt_Color_b2, Filt_Color_b1);
			    	if (Filt_Color_back_gray) {
			        	//bild in grau umwandeln
			        	IFilter _IF2 = new Grayscale(0.2125, 0.7154, 0.0721);
	        			Bitmap gray = _IF2.Apply(img);
	        			GrayscaleToRGB GRGB = new GrayscaleToRGB();
						gray = GRGB.Apply(gray);
						//grafikobjekt erstellen und farbfilter auf img2 anwenden
						Graphics G = Graphics.FromImage(gray);
						Bitmap img2 = f_col.Apply(img);
						//gefiltertes von img2 als trasparent machen
						img2.MakeTransparent(Color.Black);
						//transparentes zum grauen hinzufügen und an img übergeben
						G.DrawImage(img2,0,0);
						img = gray;
			    	} else {
				    	img = f_col.Apply(img);
        			}
			    }
			}
			if (Filt_Chan)
			{	//filtert rgb von den pixeln (weiß und rot sind nach dem filtern
				//von blau und grün >beide< rot)
		    	ChannelFiltering f_chan = new ChannelFiltering();
		    	f_chan.Red = new IntRange(Filt_Chan_r2, Filt_Chan_r1);
		        f_chan.Green = new IntRange(Filt_Chan_g2, Filt_Chan_g1);
		        f_chan.Blue = new IntRange(Filt_Chan_b2, Filt_Chan_b1);
		        img = f_chan.Apply(img);
			}
			if (Filt_EC) 
			{	//wieder irgend ein farbfilter
				EuclideanColorFiltering ec = new EuclideanColorFiltering( );
				ec.CenterColor = new RGB(Filt_EC_r, Filt_EC_g, Filt_EC_b);
        		ec.Radius = Filt_EC_rad;
				img = ec.Apply(img);
			}
			if (Filt_Rotate2) {
				RotateChannels rgb21 = new RotateChannels( );
				rgb21.ApplyInPlace(img);
				RotateChannels rgb22 = new RotateChannels( );
				rgb22.ApplyInPlace(img);
			}
			if (Filt_Rotate1) {
				RotateChannels rgb1 = new RotateChannels( );
				rgb1.ApplyInPlace(img);
			}
			if (Filt_Extract) {
				// create filter
				short ex_rgb = 0;
				if (Filt_Extract_R) { ex_rgb = RGB.R; }
				if (Filt_Extract_G) { ex_rgb = RGB.G; }
				if (Filt_Extract_B) { ex_rgb = RGB.B; }
				ExtractChannel ex = new ExtractChannel( ex_rgb );
				img = ex.Apply( img );
				GrayscaleToRGB g_rgb = new GrayscaleToRGB();
			    img = g_rgb.Apply(img);
			}
			if (Filt_PFill) {
				PointedColorFloodFill PCFF = new PointedColorFloodFill();
				PCFF.Tolerance = Color.FromArgb(Filt_PFill_R, Filt_PFill_G, Filt_PFill_B);
				PCFF.FillColor = Filt_PFill_col;
				PCFF.StartingPoint = new IntPoint(Filt_PFill_X, Filt_PFill_Y);
				PCFF.ApplyInPlace(img);
			}
        }
        
        void Drawrect(ref Bitmap image, Point p, Rectangle rect, Blob blob)
        {	//zum zeichnen auf der bildfläche
        	Graphics g = Graphics.FromImage(image);
            Pen p1 = new Pen(Filt_Blob_color, 1);
            Point px = new Point(back.X-5, back.Y);
            Point px2 = new Point(back.X+5, back.Y);
            Point py = new Point(back.X, back.Y-5);
            Point py2 = new Point(back.X, back.Y+5);
            Font f = new Font("Arial", 8);
            SolidBrush br = new SolidBrush(Filt_Blob_color);
        	//oben: komponenten erstellen... unten: komponenten darstellen
        	g.DrawRectangle(p1,rect);
	        g.DrawLine(p1,px,px2);
	        g.DrawLine(p1,py,py2);
	        g.DrawString("CenterOfGravity: "+blob.CenterOfGravity,f,br,10, image.Height -50);
	        g.DrawString("Objektpixel: "+blob.Area,f,br,10, image.Height -40);
        	g.DrawString("Größe: X="+rect.Width+" Y="+rect.Height,f,br,10, image.Height -30);
       		g.DrawString("Position: X="+rect.X+" Y="+rect.Y,f,br,10, image.Height -20);
        }
        
		void do_main_pseudocolor(ref Bitmap img)
        {
			//Bild (sicherheitshalber) in graustufen umwandeln
        	IFilter grayscale = new Grayscale( 0.2125, 0.7154, 0.0721 );
            Bitmap tmp = grayscale.Apply(img);
            
			//Bild von graustufen auf RGB setzten
			//es ändert sich äußerlich nicht, hat aber eine andere Farbscala
            GrayscaleToRGB filter1 = new GrayscaleToRGB();
			img = filter1.Apply(tmp);
			
			//Bildfarben aus der "byte color map" neu verteilen
			ColorRemapping filter2 = new ColorRemapping( map_r, map_g, map_b );
			filter2.ApplyInPlace(img);
        }
		
		void Kernel_close_all_filters()
		{
			
		} //leer
		
		void Timer_offTick(object sender, EventArgs e)
		{
			if (working) 
			{
				return;
			}
			AVI_readFrame(false);
			Bitmap img = null;
			try 
			{
				img = (Bitmap)pic_backbox.Image.Clone();
				info_err.Visible = false;
			} 
			catch (Exception err) 
			{
				info_err.Visible = true;
        		info_err.Text = "Fehler in (Timer_offTick):\r\n"+err.Message;
			}
			if (img != null)
        	{ 	
        		//wenn der vorherige durchlauf noch nicht fertig ist, bearbeitung überspringen
        		ImageProcessing(ref img);
//         		if (Filt_im_Hintergrund)
//	            {
//	            	Picbox1.Image = img;
//	            }
        	}
		}
		void Timer_onTick(object sender, EventArgs e)
		{
			if (working)
			{
				if (cam_droped < 10) 
				{
					cam_droped++;
					return;
				}
				FF.draw_sin_rainbow_palette();
				working = false;
			}
			cam_droped = 0;
			Bitmap img = new Bitmap(1,1,PixelFormat.Format24bppRgb);
			if (pic_backbox.Image != null) 
			{
				img = (Bitmap)pic_backbox.Image.Clone();
			}
			ImageProcessing(ref img);
//        	if (Filt_im_Hintergrund)
//            {
//            	Picbox1.Image = img;
//            }
		}
		#endregion
		
	}
	
	public static class do_XML
	{
		static string XMLPath = Application.ExecutablePath.Replace("Image_analyzer.exe","Setup.xml");
		public static void erstelle_XML()
		{
			XmlTextWriter xml = new XmlTextWriter(XMLPath, System.Text.Encoding.UTF8);
			xml.Formatting = Formatting.Indented;
			xml.WriteStartDocument(false);

			xml.WriteStartElement("setup");
			xml.WriteEndElement();
			
			xml.Flush();
			xml.Close();
			MessageBox.Show("XML wurde neu erstellt.");
		}
		public static void schreibe_XML(string Name, string Wert)
		{
			XmlDocument doc = new XmlDocument();
			if (File.Exists(XMLPath)) {
				doc.Load(XMLPath);
				if (doc.DocumentElement[Name] == null) {
					XmlElement elem = doc.CreateElement(Name);
				    elem.InnerText = Wert;
				    doc.DocumentElement.AppendChild(elem);
				} else {
					doc.DocumentElement[Name].InnerText = Wert;
				}
				doc.Save(XMLPath);
			} else {
				erstelle_XML();
			}
		}
		public static string lese_XML(string Name)
		{
			string output = "";
			
			XmlDocument doc = new XmlDocument();
			if (File.Exists(XMLPath)) {
				doc.Load(XMLPath);
				if (doc.DocumentElement[Name] != null)
				{
					output = doc.DocumentElement[Name].InnerText;
				}
			} else {
				erstelle_XML();
			}
			
			return output;
		}
	}

}
